/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.EmptyStatementTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="S00103", repositoryKey="squid")
@Rule(key="S103")
public class TooLongLineCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAXIMUM_LINE_LENGTH = 120;
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="120")
    int maximumLineLength = 120;
    private final Set<Integer> ignoredLines = new HashSet<Integer>();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.emptyList();
    }

    public void setContext(JavaFileScannerContext context) {
        this.ignoredLines.clear();
        this.ignoreLines(context.getTree());
        super.setContext(context);
        this.visitFile();
    }

    private void ignoreLines(CompilationUnitTree tree) {
        List imports = tree.imports();
        if (!imports.isEmpty()) {
            int start = TooLongLineCheck.getLine((ImportClauseTree)imports.get(0), true);
            int end = TooLongLineCheck.getLine((ImportClauseTree)imports.get(imports.size() - 1), false);
            for (int i = start; i <= end; ++i) {
                this.ignoredLines.add(i);
            }
        }
    }

    private static int getLine(ImportClauseTree importClauseTree, boolean fromStart) {
        if (importClauseTree.is(new Tree.Kind[]{Tree.Kind.IMPORT})) {
            if (fromStart) {
                return ((ImportTree)importClauseTree).importKeyword().line();
            }
            return ((ImportTree)importClauseTree).semicolonToken().line();
        }
        return ((EmptyStatementTree)importClauseTree).semicolonToken().line();
    }

    private void visitFile() {
        List lines = this.context.getFileLines();
        for (int i = 0; i < lines.size(); ++i) {
            String origLine;
            if (this.ignoredLines.contains(i + 1) || (origLine = (String)lines.get(i)).length() <= this.maximumLineLength || TooLongLineCheck.removeIgnoredPatterns(origLine).length() <= this.maximumLineLength) continue;
            this.addIssue(i + 1, MessageFormat.format("Split this {0} characters long line (which is greater than {1} authorized).", origLine.length(), this.maximumLineLength));
        }
    }

    private static String removeIgnoredPatterns(String line) {
        if (!line.matches("\\s*(?:\\*|//).*")) {
            return line;
        }
        return line.replaceFirst("\\{@link [^}]+\\}\\s*", "").replaceFirst("@see .+", "");
    }
}

