/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S3020")
public class ToArrayCheck
extends AbstractMethodDetection {
    private static final MethodMatchers COLLECTION_TO_ARRAY = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Collection"}).names(new String[]{"toArray"}).addWithoutParametersMatcher().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return COLLECTION_TO_ARRAY;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Tree parent = mit.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
            this.checkCast(((TypeCastTree)parent).symbolType(), mit);
        }
    }

    private void checkCast(Type type, MethodInvocationTree mit) {
        Type elementType;
        if (type.isArray() && !type.is("java.lang.Object[]") && !JUtils.isTypeVar((Type)(elementType = ((Type.ArrayType)type).elementType()))) {
            this.reportIssue((Tree)mit, "Pass \"new " + elementType.name() + "[0]\" as argument to \"toArray\".");
        }
    }
}

