/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.AbstractDeprecatedChecker;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="MissingDeprecatedCheck", repositoryKey="squid")
@Rule(key="S1123")
public class MissingDeprecatedCheck
extends AbstractDeprecatedChecker {
    private static final Tree.Kind[] CLASS_KINDS = PublicApiChecker.classKinds();
    private final Deque<Boolean> classOrInterfaceIsDeprecated = new LinkedList<Boolean>();
    private boolean isJava9 = false;

    public void setContext(JavaFileScannerContext context) {
        this.isJava9 = context.getJavaVersion().asInt() >= 9;
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        boolean isLocalVar = tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && JUtils.isLocalVariable((Symbol)((VariableTree)tree).symbol());
        AnnotationTree deprecatedAnnotation = MissingDeprecatedCheck.deprecatedAnnotation(tree);
        boolean hasDeprecatedAnnotation = deprecatedAnnotation != null;
        boolean hasJavadocDeprecatedTag = MissingDeprecatedCheck.hasJavadocDeprecatedTag(tree);
        if (this.currentClassNotDeprecated() && !isLocalVar) {
            if (hasDeprecatedAnnotation) {
                if (!hasJavadocDeprecatedTag) {
                    this.reportIssue(MissingDeprecatedCheck.getReportTree(tree), "Add the missing @deprecated Javadoc tag.");
                } else if (this.isJava9 && deprecatedAnnotation.arguments().isEmpty()) {
                    this.reportIssue(MissingDeprecatedCheck.getReportTree((Tree)deprecatedAnnotation), "Add 'since' and/or 'forRemoval' arguments to the @Deprecated annotation.");
                }
            } else if (hasJavadocDeprecatedTag) {
                this.reportIssue(MissingDeprecatedCheck.getReportTree(tree), "Add the missing @Deprecated annotation.");
            }
        }
        if (tree.is(CLASS_KINDS)) {
            this.classOrInterfaceIsDeprecated.push(hasDeprecatedAnnotation || hasJavadocDeprecatedTag);
        }
    }

    private boolean currentClassNotDeprecated() {
        return this.classOrInterfaceIsDeprecated.isEmpty() || this.classOrInterfaceIsDeprecated.peek() == false;
    }

    public void leaveNode(Tree tree) {
        if (tree.is(CLASS_KINDS)) {
            this.classOrInterfaceIsDeprecated.pop();
        }
    }
}

