/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.PatternUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="MaximumInheritanceDepth", repositoryKey="squid")
@Rule(key="S110")
public class DepthOfInheritanceTreeCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final int DEFAULT_MAX_DEPTH = 5;
    private static final List<String> FRAMEWORK_EXCLUSION_PATTERNS = Arrays.asList("android.**", "com.intellij.**", "com.persistit.**", "javax.swing.**", "org.eclipse.**", "org.springframework.**");
    private JavaFileScannerContext context;
    @RuleProperty(key="max", description="Maximum depth of the inheritance tree. (Number)", defaultValue="5")
    private Integer max = 5;
    @RuleProperty(key="filteredClasses", description="Classes to be filtered out of the count of inheritance. Ex : java.fwk.AbstractFwkClass, java.fwkPackage.*", defaultValue="")
    private String filteredClasses = "";
    private List<WildcardPattern> filteredPatterns;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitClass(ClassTree tree) {
        if (!DepthOfInheritanceTreeCheck.isBodyOfEnumConstantTree(tree)) {
            Type superClass = tree.symbol().superClass();
            int dit = 0;
            while (superClass != null) {
                String fullyQualifiedName = superClass.fullyQualifiedName();
                if (this.getPatterns().stream().anyMatch(pattern -> pattern.match(fullyQualifiedName))) break;
                ++dit;
                superClass = superClass.symbol().superClass();
            }
            if (dit > this.max) {
                IdentifierTree reportTree = tree.simpleName();
                if (tree.parent().is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                    reportTree = ((NewClassTree)tree.parent()).newKeyword();
                }
                this.context.reportIssue((JavaCheck)this, (Tree)reportTree, "This class has " + dit + " parents which is greater than " + this.max + " authorized.", new ArrayList(), Integer.valueOf(dit - this.max));
            }
        }
        super.visitClass(tree);
    }

    private static boolean isBodyOfEnumConstantTree(ClassTree tree) {
        Tree parent = tree.parent();
        return parent.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && parent.parent().is(new Tree.Kind[]{Tree.Kind.ENUM_CONSTANT});
    }

    @VisibleForTesting
    void setMax(int max) {
        this.max = max;
    }

    private List<WildcardPattern> getPatterns() {
        if (this.filteredPatterns == null) {
            String permittedPatterns = String.join((CharSequence)",", String.join((CharSequence)",", FRAMEWORK_EXCLUSION_PATTERNS), this.filteredClasses);
            this.filteredPatterns = Arrays.asList(PatternUtils.createPatterns(permittedPatterns));
        }
        return this.filteredPatterns;
    }

    public void setFilteredClasses(String filteredClasses) {
        this.filteredClasses = filteredClasses;
    }
}

