/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3052")
public class DefaultInitializedFieldCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ((ClassTree)tree).members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).forEach(this::checkVariable);
    }

    private void checkVariable(VariableTree member) {
        if (ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.FINAL)) {
            return;
        }
        ExpressionTree initializer = member.initializer();
        if (initializer != null) {
            ExpressionTree cleanedInitializer = ExpressionUtils.skipParentheses((ExpressionTree)initializer);
            DefaultInitializedFieldCheck.getIfDefault(cleanedInitializer, member.type().symbolType().isPrimitive()).ifPresent(value -> this.reportIssue((Tree)cleanedInitializer, String.format("Remove this initialization to \"%s\", the compiler will do that for you.", value)));
        }
    }

    private static Optional<String> getIfDefault(ExpressionTree expression, boolean isPrimitive) {
        if (!isPrimitive && !expression.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
            return expression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) ? DefaultInitializedFieldCheck.literalValue(expression) : Optional.empty();
        }
        switch (expression.kind()) {
            case CHAR_LITERAL: {
                return DefaultInitializedFieldCheck.literalValue(expression).filter(charValue -> "'\\u0000'".equals(charValue) || "'\\0'".equals(charValue));
            }
            case BOOLEAN_LITERAL: {
                return DefaultInitializedFieldCheck.literalValue(expression).filter(booleanValue -> LiteralUtils.isFalse((Tree)expression));
            }
            case INT_LITERAL: 
            case LONG_LITERAL: {
                return Optional.ofNullable(LiteralUtils.longLiteralValue((ExpressionTree)expression)).filter(numericalValue -> numericalValue == 0L).flatMap(numericalValue -> DefaultInitializedFieldCheck.literalValue(expression));
            }
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: {
                return DefaultInitializedFieldCheck.literalValue(expression).filter(numericalValue -> Double.doubleToLongBits(Double.valueOf(numericalValue)) == 0L);
            }
            case TYPE_CAST: {
                return DefaultInitializedFieldCheck.getIfDefault(((TypeCastTree)expression).expression(), isPrimitive);
            }
        }
        return Optional.empty();
    }

    private static Optional<String> literalValue(ExpressionTree expression) {
        return Optional.of(((LiteralTree)expression).value());
    }
}

