/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S2147")
public class CombineCatchCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TRY_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ArrayList<CatchTree> catches = new ArrayList<CatchTree>();
        for (CatchTree catchTree : ((TryStatementTree)tree).catches()) {
            for (CatchTree catchTreeToBeCompared : catches) {
                if (!SyntacticEquivalence.areSemanticallyEquivalent((List)catchTree.block().body(), (List)catchTreeToBeCompared.block().body())) continue;
                this.reportIssue(catchTree, catchTreeToBeCompared);
                break;
            }
            catches.add(catchTree);
        }
    }

    private void reportIssue(CatchTree catchTree, CatchTree catchTreeToBeCompared) {
        String message = "Combine this catch with the one at line " + catchTreeToBeCompared.catchKeyword().line() + ", which has the same body." + this.context.getJavaVersion().java7CompatibilityMessage();
        List<JavaFileScannerContext.Location> flow = Collections.singletonList(new JavaFileScannerContext.Location("Combine with this catch", (Tree)catchTreeToBeCompared));
        this.reportIssue((Tree)catchTree.parameter(), message, flow, null);
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava7Compatible();
    }
}

