/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3878")
public class ArrayForVarArgCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        Symbol.MethodSymbol methodSymbol;
        Arguments args;
        Symbol sym;
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            NewClassTree nct = (NewClassTree)tree;
            sym = nct.constructorSymbol();
            args = nct.arguments();
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            sym = mit.symbol();
            args = mit.arguments();
        }
        if (sym.isMethodSymbol() && ArrayForVarArgCheck.isLastArgumentVarargs(methodSymbol = (Symbol.MethodSymbol)sym, args)) {
            ExpressionTree lastArg = (ExpressionTree)args.get(args.size() - 1);
            this.checkInvokedMethod(methodSymbol, lastArg);
        }
    }

    private void checkInvokedMethod(Symbol.MethodSymbol methodSymbol, ExpressionTree lastArg) {
        if (lastArg.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            Type lastParamType = ArrayForVarArgCheck.getLastParameterType(methodSymbol.parameterTypes());
            Type lastArgType = lastArg.symbolType();
            if (lastParamType.isUnknown() || lastArgType.isUnknown()) {
                return;
            }
            if (lastArgType.equals(lastParamType)) {
                this.reportIssueForSameType(methodSymbol, (NewArrayTree)lastArg);
            } else {
                String type = ((Type.ArrayType)lastParamType).elementType().name();
                this.reportIssue((Tree)lastArg, "Disambiguate this call by either casting as \"" + type + "\" or \"" + type + "[]\".");
            }
        }
    }

    private void reportIssueForSameType(Symbol.MethodSymbol methodSymbol, NewArrayTree newArrayTree) {
        String message = "Remove this array creation";
        if (newArrayTree.openBraceToken() == null) {
            ExpressionTree expression = ((ArrayDimensionTree)newArrayTree.dimensions().get(0)).expression();
            Integer literalValue = LiteralUtils.intLiteralValue((ExpressionTree)expression);
            if (literalValue == null || literalValue != 0 || ArrayForVarArgCheck.isCallingOverload(methodSymbol, (ExpressionTree)newArrayTree)) {
                return;
            }
        } else if (!newArrayTree.initializers().isEmpty()) {
            message = message + " and simply pass the elements";
        }
        this.reportIssue((Tree)newArrayTree, message + ".");
    }

    private static boolean isLastArgumentVarargs(Symbol.MethodSymbol methodSymbol, Arguments args) {
        return !args.isEmpty() && JUtils.isVarArgsMethod((Symbol.MethodSymbol)methodSymbol) && args.size() == methodSymbol.parameterTypes().size();
    }

    private static Type getLastParameterType(List<? extends Type> list) {
        return list.get(list.size() - 1);
    }

    private static boolean isCallingOverload(Symbol.MethodSymbol methodSymbol, ExpressionTree lastArg) {
        MethodTree enclosing = ExpressionUtils.getEnclosingMethod((ExpressionTree)lastArg);
        return enclosing != null && ArrayForVarArgCheck.haveSameParamButLast(enclosing.symbol(), methodSymbol);
    }

    private static boolean haveSameParamButLast(Symbol.MethodSymbol enclosing, Symbol.MethodSymbol methodSymbol) {
        return enclosing.name().equals(methodSymbol.name()) && IntStream.range(0, enclosing.parameterTypes().size()).allMatch(i -> enclosing.parameterTypes().get(i) == methodSymbol.parameterTypes().get(i));
    }
}

