/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.CharacterRangeTree;
import org.sonar.java.regex.ast.EscapedCharacterClassTree;
import org.sonar.java.regex.ast.NonCapturingGroupTree;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5867")
public class UnicodeAwareCharClassesCheck
extends AbstractRegexCheck {
    private static final Set<Character> unicodeAwareClassesWithFlag = ImmutableSet.of((Object)Character.valueOf('s'), (Object)Character.valueOf('S'), (Object)Character.valueOf('w'), (Object)Character.valueOf('W'));
    private static final Set<String> unicodeAwarePropertiesWithFlag = ImmutableSet.of((Object)"Lower", (Object)"Upper", (Object)"Alpha", (Object)"Alnum", (Object)"Punct", (Object)"Graph", (Object[])new String[]{"Print", "Blank", "Space"});
    private static final Map<Character, Character> unicodeUnawareCharacterRanges = ImmutableMap.of((Object)Character.valueOf('a'), (Object)Character.valueOf('z'), (Object)Character.valueOf('A'), (Object)Character.valueOf('Z'));

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, MethodInvocationTree mit) {
        new UnicodeUnawareCharClassFinder(mit).visit(regexForLiterals);
    }

    private class UnicodeUnawareCharClassFinder
    extends RegexBaseVisitor {
        private final MethodInvocationTree mit;
        private final List<RegexTree> unicodeUnawareRange = new ArrayList<RegexTree>();
        private final List<RegexTree> unicodeAwareWithFlag = new ArrayList<RegexTree>();
        private boolean containsUnicodeCharacterFlag = false;

        public UnicodeUnawareCharClassFinder(MethodInvocationTree mit) {
            this.mit = mit;
        }

        protected void before(RegexParseResult regexParseResult) {
            this.containsUnicodeCharacterFlag |= regexParseResult.getInitialFlags().contains(256);
        }

        protected void after(RegexParseResult regexParseResult) {
            List<RegexCheck.RegexIssueLocation> secondaries;
            int unicodeUnawareRangeSize = this.unicodeUnawareRange.size();
            if (unicodeUnawareRangeSize == 1) {
                UnicodeAwareCharClassesCheck.this.reportIssue((RegexSyntaxElement)this.unicodeUnawareRange.get(0), "Replace this character range with a Unicode-aware character class.", null, Collections.emptyList());
            } else if (unicodeUnawareRangeSize > 1) {
                secondaries = this.unicodeUnawareRange.stream().map(tree -> new RegexCheck.RegexIssueLocation((RegexSyntaxElement)tree, "Character range")).collect(Collectors.toList());
                UnicodeAwareCharClassesCheck.this.reportIssue((RegexSyntaxElement)regexParseResult.getResult(), "Replace these character ranges with Unicode-aware character classes.", null, secondaries);
            }
            if (!this.unicodeAwareWithFlag.isEmpty() && !this.containsUnicodeCharacterFlag) {
                secondaries = this.unicodeAwareWithFlag.stream().map(tree -> new RegexCheck.RegexIssueLocation((RegexSyntaxElement)tree, "Predefined/POSIX character class")).collect(Collectors.toList());
                UnicodeAwareCharClassesCheck.this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)this.mit), "Enable the \"UNICODE_CHARACTER_CLASS\" flag or use a Unicode-aware alternative.", null, secondaries);
            }
        }

        public void visitCharacterRange(CharacterRangeTree tree) {
            Character expectedUpperBoundChar;
            int lowerBound = tree.getLowerBound().codePointOrUnit();
            if (lowerBound < 65535 && (expectedUpperBoundChar = (Character)unicodeUnawareCharacterRanges.get(Character.valueOf((char)lowerBound))) != null && expectedUpperBoundChar.charValue() == tree.getUpperBound().codePointOrUnit()) {
                this.unicodeUnawareRange.add((RegexTree)tree);
            }
        }

        public void visitEscapedCharacterClass(EscapedCharacterClassTree tree) {
            String property = tree.property();
            if (property != null && unicodeAwarePropertiesWithFlag.contains(property) || unicodeAwareClassesWithFlag.contains(Character.valueOf(tree.getType()))) {
                this.unicodeAwareWithFlag.add((RegexTree)tree);
            }
        }

        protected void doVisitNonCapturingGroup(NonCapturingGroupTree tree) {
            this.containsUnicodeCharacterFlag |= this.flagActive(256);
            super.doVisitNonCapturingGroup(tree);
        }
    }
}

