/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.CharacterClassTree;
import org.sonar.java.regex.ast.EscapedCharacterClassTree;
import org.sonar.java.regex.ast.Quantifier;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RepetitionTree;
import org.sonar.java.regex.ast.SequenceTree;
import org.sonar.java.regex.ast.SimpleQuantifier;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S5857")
public class ReluctantQuantifierCheck
extends AbstractRegexCheck {
    @Override
    public void checkRegex(RegexParseResult regexForLiterals, MethodInvocationTree mit) {
        new ReluctantQuantifierFinder().visit(regexForLiterals);
    }

    private class ReluctantQuantifierFinder
    extends RegexBaseVisitor {
        private ReluctantQuantifierFinder() {
        }

        public void visitSequence(SequenceTree tree) {
            RepetitionTree repetition;
            super.visitSequence(tree);
            List items = tree.getItems();
            if (items.size() >= 2 && ((RegexTree)items.get(items.size() - 2)).is(new RegexTree.Kind[]{RegexTree.Kind.REPETITION}) && this.isReluctantlyQuantifiedDot(repetition = (RepetitionTree)items.get(items.size() - 2))) {
                this.findNegatedCharacterClassFor((RegexTree)items.get(items.size() - 1)).ifPresent(negatedClass -> {
                    String newQuantifier = this.makePossessive(repetition.getQuantifier());
                    String message = String.format("Replace this use of a reluctant quantifier with \"%s%s\".", negatedClass, newQuantifier);
                    ReluctantQuantifierCheck.this.reportIssue((RegexSyntaxElement)repetition, String.format(message, negatedClass), null, Collections.emptyList());
                });
            }
        }

        private boolean isReluctantlyQuantifiedDot(RepetitionTree repetition) {
            return repetition.getQuantifier().getModifier() == Quantifier.Modifier.RELUCTANT && !repetition.getQuantifier().isFixed() && repetition.getElement().is(new RegexTree.Kind[]{RegexTree.Kind.DOT});
        }

        private String makePossessive(Quantifier quantifier) {
            if (quantifier instanceof SimpleQuantifier) {
                return ((SimpleQuantifier)quantifier).getKind() + "+";
            }
            String max = Optional.ofNullable(quantifier.getMaximumRepetitions()).map(Object::toString).orElse("");
            return String.format("{%d,%s}+", quantifier.getMinimumRepetitions(), max);
        }

        private Optional<String> findNegatedCharacterClassFor(RegexTree tree) {
            String result;
            switch (tree.kind()) {
                case PLAIN_CHARACTER: 
                case UNICODE_CODE_POINT: {
                    result = "[^" + tree.getText() + "]";
                    break;
                }
                case ESCAPED_CHARACTER_CLASS: {
                    EscapedCharacterClassTree escapedClass = (EscapedCharacterClassTree)tree;
                    result = "\\\\" + this.negateEscapedCharacterClassType(escapedClass.getType());
                    if (!escapedClass.isProperty()) break;
                    result = result + "{" + escapedClass.property() + "}";
                    break;
                }
                case CHARACTER_CLASS: {
                    CharacterClassTree characterClass = (CharacterClassTree)tree;
                    String body = characterClass.getContents().getText();
                    if (characterClass.isNegated()) {
                        result = "[" + body + "]";
                        break;
                    }
                    result = "[^" + body + "]";
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            return Optional.of(result);
        }

        private char negateEscapedCharacterClassType(char type) {
            return Character.isLowerCase(type) ? Character.toUpperCase(type) : Character.toLowerCase(type);
        }
    }
}

