/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S2140")
public class RandomFloatToIntCheck
extends IssuableSubscriptionVisitor {
    private static final String NEXT_FLOAT = "nextFloat";
    private static final String NEXT_DOUBLE = "nextDouble";
    private static final MethodMatchers MATH_RANDOM_METHOD_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.lang.Math"}).names(new String[]{"random"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers METHOD_MATCHERS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.concurrent.ThreadLocalRandom"}).names(new String[]{"nextDouble"}).withAnyParameters().build(), MethodMatchers.create().ofTypes(new String[]{"java.util.Random", "org.apache.commons.lang.math.JVMRandom", "org.apache.commons.lang.math.RandomUtils", "org.apache.commons.lang3.RandomUtils"}).names(new String[]{"nextDouble", "nextFloat"}).addWithoutParametersMatcher().build()});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TYPE_CAST);
    }

    public void visitNode(Tree tree) {
        TypeCastTree castTree = (TypeCastTree)tree;
        if (castTree.type().symbolType().is("int")) {
            castTree.expression().accept((TreeVisitor)new RandomDoubleVisitor());
        }
    }

    private class RandomDoubleVisitor
    extends BaseTreeVisitor {
        private RandomDoubleVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (MATH_RANDOM_METHOD_MATCHER.matches(tree)) {
                RandomFloatToIntCheck.this.reportIssue((Tree)tree.methodSelect(), "Use \"java.util.Random.nextInt()\" instead.");
            } else if (METHOD_MATCHERS.matches(tree)) {
                RandomFloatToIntCheck.this.reportIssue((Tree)tree.methodSelect(), "Use \"nextInt()\" instead.");
            }
            super.visitMethodInvocation(tree);
        }

        public void visitNewClass(NewClassTree tree) {
            this.scan((Tree)tree.enclosingExpression());
            this.scan((Tree)tree.identifier());
            this.scan((ListTree)tree.typeArguments());
            this.scan((ListTree)tree.arguments());
        }
    }
}

