/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4347")
public class PredictableSeedCheck
extends AbstractMethodDetection {
    private static final Tree.Kind[] LITERAL_KINDS = new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL};
    private static final String JAVA_SECURITY_SECURE_RANDOM = "java.security.SecureRandom";
    private static final MethodMatchers GET_BYTES = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"getBytes"}).withAnyParameters().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{JAVA_SECURITY_SECURE_RANDOM}).constructor().addParametersMatcher(new String[]{"byte[]"}).build(), MethodMatchers.create().ofTypes(new String[]{JAVA_SECURITY_SECURE_RANDOM}).names(new String[]{"setSeed"}).addParametersMatcher(new String[]{"byte[]"}).addParametersMatcher(new String[]{"long"}).build()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.checkSeed((ExpressionTree)mit.arguments().get(0));
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.checkSeed((ExpressionTree)newClassTree.arguments().get(0));
    }

    private void checkSeed(ExpressionTree seedExpression) {
        if (PredictableSeedCheck.isPredictable(seedExpression)) {
            this.reportIssue((Tree)seedExpression, "Change this seed value to something unpredictable, or remove the seed.");
        }
    }

    private static boolean isPredictable(ExpressionTree expressionTree) {
        return expressionTree.is(LITERAL_KINDS) || PredictableSeedCheck.isStaticFinal(expressionTree) || expressionTree.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY}) || PredictableSeedCheck.isStringLiteralToBytes(expressionTree);
    }

    private static boolean isStringLiteralToBytes(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && GET_BYTES.matches((MethodInvocationTree)expressionTree)) {
            return ((MemberSelectExpressionTree)((MethodInvocationTree)expressionTree).methodSelect()).expression().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
        }
        return false;
    }

    private static boolean isStaticFinal(ExpressionTree expressionTree) {
        return expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ((IdentifierTree)expressionTree).symbol().isStatic() && ((IdentifierTree)expressionTree).symbol().isFinal();
    }
}

