/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4349")
public class OutputStreamOverrideWriteCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers WRITE_BYTES_INT_INT = MethodMatchers.create().ofAnyType().names(new String[]{"write"}).addParametersMatcher(new String[]{"byte[]", "int", "int"}).build();
    private static final MethodMatchers WRITE_INT = MethodMatchers.create().ofAnyType().names(new String[]{"write"}).addParametersMatcher(new String[]{"int"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        Type superType = classTree.symbol().superClass();
        IdentifierTree className = classTree.simpleName();
        if (className == null || classTree.symbol().isAbstract() || superType == null || !superType.is("java.io.OutputStream") && !superType.is("java.io.FilterOutputStream")) {
            return;
        }
        Optional<MethodTree> writeByteIntInt = OutputStreamOverrideWriteCheck.findMethod(classTree, WRITE_BYTES_INT_INT);
        if (!writeByteIntInt.isPresent()) {
            MethodTree writeIntTree;
            String message = "Provide an override of \"write(byte[],int,int)\" for this class.";
            Optional<MethodTree> writeInt = OutputStreamOverrideWriteCheck.findMethod(classTree, WRITE_INT);
            if (writeInt.isPresent() && (writeIntTree = writeInt.get()).block().body().isEmpty()) {
                message = "Provide an empty override of \"write(byte[],int,int)\" for this class as well.";
            }
            this.reportIssue((Tree)className, message);
        }
    }

    private static Optional<MethodTree> findMethod(ClassTree classTree, MethodMatchers methodMatcher) {
        return classTree.members().stream().filter(m -> m.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(m -> (MethodTree)m).filter(arg_0 -> ((MethodMatchers)methodMatcher).matches(arg_0)).findFirst();
    }
}

