/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.se.NullableAnnotationUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2789")
public class NullShouldNotBeUsedWithOptionalCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final List<String> OPTIONAL_CLASSES = Arrays.asList("java.util.Optional", "com.google.common.base.Optional");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree method) {
        if (!method.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) && NullShouldNotBeUsedWithOptionalCheck.returnsOptional(method)) {
            this.checkNullableAnnotation(method.modifiers(), "Methods with an \"Optional\" return type should not be \"%s\".");
            method.accept((TreeVisitor)new ReturnNullVisitor());
        }
        super.visitMethod(method);
    }

    public void visitBinaryExpression(BinaryExpressionTree binaryExpression) {
        if (binaryExpression.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO})) {
            ExpressionTree left = binaryExpression.leftOperand();
            ExpressionTree right = binaryExpression.rightOperand();
            if (NullShouldNotBeUsedWithOptionalCheck.isOptional(left) && NullShouldNotBeUsedWithOptionalCheck.isNull(right) || NullShouldNotBeUsedWithOptionalCheck.isNull(left) && NullShouldNotBeUsedWithOptionalCheck.isOptional(right)) {
                this.context.reportIssue((JavaCheck)this, (Tree)binaryExpression, "Ensure this \"Optional\" could never be null and remove this null-check.");
            }
        }
        super.visitBinaryExpression(binaryExpression);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree assignment) {
        if (NullShouldNotBeUsedWithOptionalCheck.isOptional(assignment.variable()) && NullShouldNotBeUsedWithOptionalCheck.isNull(assignment.expression())) {
            this.context.reportIssue((JavaCheck)this, (Tree)assignment.expression(), "Replace this null literal by an \"Optional\" object.");
        }
        super.visitAssignmentExpression(assignment);
    }

    public void visitVariable(VariableTree variable) {
        if (NullShouldNotBeUsedWithOptionalCheck.isOptionalType(variable.type())) {
            this.checkNullableAnnotation(variable.modifiers(), "\"Optional\" variables should not be \"%s\".");
            ExpressionTree initializer = variable.initializer();
            if (initializer != null && NullShouldNotBeUsedWithOptionalCheck.isNull(initializer)) {
                this.context.reportIssue((JavaCheck)this, (Tree)initializer, "Replace this null literal by an \"Optional\" object.");
            }
        }
        super.visitVariable(variable);
    }

    private static boolean returnsOptional(MethodTree method) {
        return NullShouldNotBeUsedWithOptionalCheck.isOptionalType(method.returnType());
    }

    private static boolean isOptional(ExpressionTree expression) {
        return NullShouldNotBeUsedWithOptionalCheck.isOptionalType(expression) && !NullShouldNotBeUsedWithOptionalCheck.isNull(expression);
    }

    private static boolean isOptionalType(TypeTree type) {
        return NullShouldNotBeUsedWithOptionalCheck.isOptionalType(type.symbolType());
    }

    private static boolean isOptionalType(ExpressionTree expression) {
        return NullShouldNotBeUsedWithOptionalCheck.isOptionalType(expression.symbolType());
    }

    private static boolean isOptionalType(Type type) {
        return OPTIONAL_CLASSES.contains(type.fullyQualifiedName());
    }

    private static boolean isNull(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }

    private void checkNullableAnnotation(ModifiersTree modifiers, String messageFormat) {
        NullableAnnotationUtils.nullableAnnotation((ModifiersTree)modifiers).ifPresent(annotation -> this.context.reportIssue((JavaCheck)this, (Tree)annotation, String.format(messageFormat, "@" + annotation.annotationType().symbolType().name())));
    }

    private class ReturnNullVisitor
    extends BaseTreeVisitor {
        private ReturnNullVisitor() {
        }

        public void visitReturnStatement(ReturnStatementTree returnStatement) {
            this.checkNull(returnStatement.expression());
            super.visitReturnStatement(returnStatement);
        }

        public void visitConditionalExpression(ConditionalExpressionTree conditionalExpression) {
            if (NullShouldNotBeUsedWithOptionalCheck.isOptionalType((ExpressionTree)conditionalExpression)) {
                this.checkNull(conditionalExpression.trueExpression());
                this.checkNull(conditionalExpression.falseExpression());
            }
            super.visitConditionalExpression(conditionalExpression);
        }

        private void checkNull(ExpressionTree expression) {
            if (NullShouldNotBeUsedWithOptionalCheck.isNull(expression)) {
                NullShouldNotBeUsedWithOptionalCheck.this.context.reportIssue((JavaCheck)NullShouldNotBeUsedWithOptionalCheck.this, (Tree)expression, "Methods with an \"Optional\" return type should never return null.");
            }
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

