/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1193")
public class InstanceofUsedOnExceptionCheck
extends IssuableSubscriptionVisitor {
    private final Set<String> caughtVariables = new HashSet<String>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CATCH, Tree.Kind.INSTANCE_OF);
    }

    public void setContext(JavaFileScannerContext context) {
        this.caughtVariables.clear();
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CATCH})) {
            this.caughtVariables.add(((CatchTree)tree).parameter().simpleName().name());
        } else {
            InstanceOfTree instanceOfTree = (InstanceOfTree)tree;
            if (this.isLeftOperandAndException(instanceOfTree) && instanceOfTree.type().symbolType().isSubtypeOf("java.lang.Throwable")) {
                this.reportIssue((Tree)instanceOfTree.instanceofKeyword(), "Replace the usage of the \"instanceof\" operator by a catch block.");
            }
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CATCH})) {
            this.caughtVariables.remove(((CatchTree)tree).parameter().simpleName().name());
        }
    }

    private boolean isLeftOperandAndException(InstanceOfTree tree) {
        return tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.caughtVariables.contains(((IdentifierTree)tree.expression()).name());
    }
}

