/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractHashAlgorithmChecker;

@Rule(key="S2070")
public class DeprecatedHashAlgorithmCheck
extends AbstractHashAlgorithmChecker {
    private static final String MESSAGE_FORMAT = "Don't rely on %s because it is deprecated and use a stronger hashing algorithm.";
    public static final Map<String, String> MESSAGE_PER_CLASS = ImmutableMap.builder().put((Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MD5.classFqn, (Object)"Use a stronger hashing algorithm than MD5.").put((Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.SHA.classFqn, (Object)("Don't rely on " + AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.SHA.className + " because it is deprecated.")).put((Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.LDAP.classFqn, (Object)String.format("Don't rely on %s because it is deprecated and use a stronger hashing algorithm.", AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.LDAP.className)).put((Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MD4.classFqn, (Object)String.format("Don't rely on %s because it is deprecated and use a stronger hashing algorithm.", AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MD4.className)).put((Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MESSAGE_DIGEST.classFqn, (Object)String.format("Don't rely on %s because it is deprecated and use a stronger hashing algorithm.", AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.MESSAGE_DIGEST.className)).put((Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.NO_OP.classFqn, (Object)"Use a stronger hashing algorithm than this fake one.").put((Object)AbstractHashAlgorithmChecker.DeprecatedSpringPasswordEncoder.STANDARD.classFqn, (Object)"Use a stronger hashing algorithm.").build();

    @Override
    protected Optional<String> getMessageForClass(String className) {
        return Optional.ofNullable(MESSAGE_PER_CLASS.get(className));
    }

    @Override
    protected String getMessageForAlgorithm(String algorithmName) {
        return "Use a stronger hashing algorithm than " + algorithmName + ".";
    }
}

