/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2278")
public class AvoidDESCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"javax.crypto.Cipher"}).names(new String[]{"getInstance"}).withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree firstArg = (ExpressionTree)mit.arguments().get(0);
        ExpressionTree defaultPropertyValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(firstArg);
        if (defaultPropertyValue == null) {
            defaultPropertyValue = firstArg;
        }
        if (defaultPropertyValue.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.checkIssue(firstArg, (LiteralTree)defaultPropertyValue);
        }
    }

    private void checkIssue(ExpressionTree argumentForReport, LiteralTree argument) {
        String[] transformationElements = LiteralUtils.trimQuotes((String)argument.value()).split("/");
        if (transformationElements.length > 0 && AvoidDESCheck.isExcludedAlgorithm(transformationElements[0])) {
            this.reportIssue((Tree)argumentForReport, "Use the recommended AES (Advanced Encryption Standard) instead.");
        }
    }

    private static boolean isExcludedAlgorithm(String algorithm) {
        return "DES".equals(algorithm) || "DESede".equals(algorithm) || "RC2".equals(algorithm);
    }
}

