/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.synchronization;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3067")
public class SynchronizationOnGetClassCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers GET_CLASS_MATCHER = MethodMatchers.create().ofAnyType().names(new String[]{"getClass"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.SYNCHRONIZED_STATEMENT);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree synchronizedExpr;
        if (!this.hasSemantic()) {
            return;
        }
        SynchronizedStatementTree synchronizedTree = (SynchronizedStatementTree)tree;
        if (synchronizedTree.expression().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && GET_CLASS_MATCHER.matches(synchronizedExpr = (MethodInvocationTree)synchronizedTree.expression()) && !SynchronizationOnGetClassCheck.isEnclosingClassFinal(synchronizedExpr.methodSelect())) {
            this.reportIssue((Tree)synchronizedExpr, "Synchronize on the static class name instead.");
        }
    }

    private static boolean isEnclosingClassFinal(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            MethodTree methodTree = SynchronizationOnGetClassCheck.findMethodTreeAncestor(expressionTree);
            if (methodTree != null) {
                return methodTree.symbol().owner().isFinal();
            }
            return SynchronizationOnGetClassCheck.findClassTreeAncestor(expressionTree).symbol().isFinal();
        }
        return ((MemberSelectExpressionTree)expressionTree).expression().symbolType().symbol().isFinal();
    }

    private static ClassTree findClassTreeAncestor(ExpressionTree expressionTree) {
        Tree parent = expressionTree.parent();
        while (!parent.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM})) {
            parent = parent.parent();
        }
        return (ClassTree)parent;
    }

    private static MethodTree findMethodTreeAncestor(ExpressionTree expressionTree) {
        for (Tree parent = expressionTree.parent(); parent != null; parent = parent.parent()) {
            if (!parent.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR})) continue;
            return (MethodTree)parent;
        }
        return null;
    }
}

