/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3752")
public class SpringRequestMappingMethodCheck
extends IssuableSubscriptionVisitor {
    private static final String REQUEST_MAPPING_CLASS = "org.springframework.web.bind.annotation.RequestMapping";
    private static final String REQUEST_METHOD = "method";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        SpringRequestMappingMethodCheck.findRequestMappingAnnotation(classTree.modifiers()).flatMap(SpringRequestMappingMethodCheck::findRequestMethod).filter(SpringRequestMappingMethodCheck::hasMoreThanOneValue).ifPresent(assignment -> this.reportIssue((Tree)assignment.expression(), "Consider narrowing this list of methods to one."));
        classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).forEach(member -> this.checkMethod((MethodTree)member, classTree.symbol()));
    }

    private void checkMethod(MethodTree method, Symbol.TypeSymbol classSymbol) {
        Optional<AnnotationTree> requestMappingAnnotation = SpringRequestMappingMethodCheck.findRequestMappingAnnotation(method.modifiers());
        Optional requestMethod = requestMappingAnnotation.flatMap(SpringRequestMappingMethodCheck::findRequestMethod);
        if (requestMethod.isPresent()) {
            requestMethod.filter(SpringRequestMappingMethodCheck::hasMoreThanOneValue).ifPresent(assignment -> this.reportIssue((Tree)assignment.expression(), "Consider narrowing this list of methods to one."));
        } else if (requestMappingAnnotation.isPresent() && !SpringRequestMappingMethodCheck.inheritRequestMethod(classSymbol)) {
            this.reportIssue((Tree)requestMappingAnnotation.get().annotationType(), "Add a \"method\" parameter to this \"@RequestMapping\" annotation.");
        }
    }

    private static Optional<AnnotationTree> findRequestMappingAnnotation(ModifiersTree modifiers) {
        return modifiers.annotations().stream().filter(annotation -> annotation.symbolType().is(REQUEST_MAPPING_CLASS)).findFirst();
    }

    private static Optional<AssignmentExpressionTree> findRequestMethod(AnnotationTree annotation) {
        return annotation.arguments().stream().map(SpringRequestMappingMethodCheck::findRequestMethod).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private static Optional<AssignmentExpressionTree> findRequestMethod(ExpressionTree argument) {
        AssignmentExpressionTree assignment;
        if (argument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && REQUEST_METHOD.equals(((IdentifierTree)(assignment = (AssignmentExpressionTree)argument).variable()).name())) {
            return Optional.of(assignment);
        }
        return Optional.empty();
    }

    private static boolean hasMoreThanOneValue(AssignmentExpressionTree assignment) {
        if (assignment.expression().is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            return ((NewArrayTree)assignment.expression()).initializers().size() > 1;
        }
        return false;
    }

    private static boolean inheritRequestMethod(Symbol.TypeSymbol symbol) {
        List annotationValues = symbol.metadata().valuesForAnnotation(REQUEST_MAPPING_CLASS);
        if (annotationValues != null && annotationValues.stream().anyMatch(value -> REQUEST_METHOD.equals(value.name()))) {
            return true;
        }
        Type superClass = symbol.superClass();
        if (superClass != null && SpringRequestMappingMethodCheck.inheritRequestMethod(superClass.symbol())) {
            return true;
        }
        for (Type type : symbol.interfaces()) {
            if (!SpringRequestMappingMethodCheck.inheritRequestMethod(type.symbol())) continue;
            return true;
        }
        return false;
    }
}

