/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2245")
public class PseudoRandomCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make sure that using this pseudorandom number generator is safe here.";
    private static final MethodMatchers MATH_RANDOM_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.lang.Math"}).names(new String[]{"random"}).addWithoutParametersMatcher().build();
    private static final Set<String> RANDOM_STATIC_TYPES = ImmutableSet.of((Object)"java.util.concurrent.ThreadLocalRandom", (Object)"org.apache.commons.lang.math.RandomUtils", (Object)"org.apache.commons.lang3.RandomUtils", (Object)"org.apache.commons.lang.RandomStringUtils", (Object)"org.apache.commons.lang3.RandomStringUtils");
    private static final Set<String> RANDOM_CONSTRUCTOR_TYPES = ImmutableSet.of((Object)"java.util.Random", (Object)"org.apache.commons.lang.math.JVMRandom");

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            Type expressionType;
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            IdentifierTree reportLocation = ExpressionUtils.methodName((MethodInvocationTree)mit);
            if (MATH_RANDOM_MATCHER.matches(mit)) {
                this.reportIssue((Tree)reportLocation, MESSAGE);
            } else if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && !PseudoRandomCheck.isChainedMethodInvocation(mit) && RANDOM_STATIC_TYPES.contains((expressionType = ((MemberSelectExpressionTree)mit.methodSelect()).expression().symbolType()).fullyQualifiedName())) {
                this.reportIssue((Tree)reportLocation, MESSAGE);
            }
        } else {
            NewClassTree newClass = (NewClassTree)tree;
            if (RANDOM_CONSTRUCTOR_TYPES.contains(newClass.symbolType().fullyQualifiedName())) {
                this.reportIssue((Tree)newClass.identifier(), MESSAGE);
            }
        }
    }

    private static boolean isChainedMethodInvocation(MethodInvocationTree mit) {
        Tree parent = mit.parent();
        return parent != null && parent.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT});
    }
}

