/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S4143")
public class OverwrittenKeyCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers MAP_PUT = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"}).names(new String[]{"put"}).addParametersMatcher(new String[]{"*", "*"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.BLOCK);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ArrayListMultimap usedKeys = ArrayListMultimap.create();
        for (StatementTree statementTree : ((BlockTree)tree).body()) {
            CollectionAndKey mapPut = OverwrittenKeyCheck.isMapPut(statementTree);
            if (mapPut != null) {
                usedKeys.put((Object)mapPut, (Object)mapPut.keyTree);
                continue;
            }
            CollectionAndKey arrayAssignment = OverwrittenKeyCheck.isArrayAssignment(statementTree);
            if (arrayAssignment != null) {
                if (arrayAssignment.collectionOnRHS()) {
                    usedKeys.clear();
                }
                usedKeys.put((Object)arrayAssignment, (Object)arrayAssignment.keyTree);
                continue;
            }
            this.reportOverwrittenKeys((ListMultimap<CollectionAndKey, Tree>)usedKeys);
            usedKeys.clear();
        }
        this.reportOverwrittenKeys((ListMultimap<CollectionAndKey, Tree>)usedKeys);
    }

    private void reportOverwrittenKeys(ListMultimap<CollectionAndKey, Tree> usedKeys) {
        Multimaps.asMap(usedKeys).forEach((key, trees) -> {
            if (trees.size() > 1) {
                Tree firstUse = (Tree)trees.get(0);
                Tree firstOverwrite = (Tree)trees.get(1);
                List<Tree> rest = trees.subList(2, trees.size());
                this.reportIssue(firstOverwrite, "Verify this is the " + ((CollectionAndKey)key).indexOrKey() + " that was intended; it was already set before.", OverwrittenKeyCheck.secondaryLocations(key, firstUse, rest), 0);
            }
        });
    }

    private static List<JavaFileScannerContext.Location> secondaryLocations(CollectionAndKey key, Tree firstUse, List<Tree> rest) {
        return Stream.concat(Stream.of(new JavaFileScannerContext.Location("Original value", firstUse)), rest.stream().map(t -> new JavaFileScannerContext.Location("Same " + key.indexOrKey() + " is set", t))).collect(Collectors.toList());
    }

    @CheckForNull
    private static Symbol symbolFromIdentifier(ExpressionTree collectionExpression) {
        Symbol symbol;
        if (collectionExpression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && !(symbol = ((IdentifierTree)collectionExpression).symbol()).isUnknown()) {
            return symbol;
        }
        return null;
    }

    @CheckForNull
    private static CollectionAndKey isArrayAssignment(StatementTree statementTree) {
        AssignmentExpressionTree assignment;
        ExpressionTree variable;
        ExpressionTree expression;
        if (statementTree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) && (expression = ((ExpressionStatementTree)statementTree).expression()).is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && (variable = (assignment = (AssignmentExpressionTree)expression).variable()).is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION})) {
            ArrayAccessExpressionTree aaet = (ArrayAccessExpressionTree)variable;
            Symbol collection = OverwrittenKeyCheck.symbolFromIdentifier(aaet.expression());
            ExpressionTree keyTree = aaet.dimension().expression();
            Object key = OverwrittenKeyCheck.extractKey(keyTree);
            if (collection != null && key != null) {
                return new CollectionAndKey(collection, (Tree)keyTree, key, true, assignment.expression());
            }
        }
        return null;
    }

    @CheckForNull
    private static CollectionAndKey isMapPut(StatementTree statementTree) {
        ExpressionTree expression;
        if (statementTree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) && (expression = ((ExpressionStatementTree)statementTree).expression()).is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && MAP_PUT.matches((MethodInvocationTree)expression)) {
            MethodInvocationTree mapPut = (MethodInvocationTree)expression;
            Symbol collection = mapPut.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? OverwrittenKeyCheck.symbolFromIdentifier(((MemberSelectExpressionTree)mapPut.methodSelect()).expression()) : null;
            ExpressionTree keyTree = (ExpressionTree)mapPut.arguments().get(0);
            Object key = OverwrittenKeyCheck.extractKey(keyTree);
            if (collection != null && key != null) {
                return new CollectionAndKey(collection, (Tree)keyTree, key, false, null);
            }
        }
        return null;
    }

    @CheckForNull
    private static Object extractKey(ExpressionTree keyArgument) {
        if (keyArgument instanceof LiteralTree) {
            return ((LiteralTree)keyArgument).value();
        }
        return OverwrittenKeyCheck.symbolFromIdentifier(keyArgument);
    }

    private static class FindSymbolUsage
    extends BaseTreeVisitor {
        private final Symbol symbol;
        private boolean used;

        public FindSymbolUsage(Symbol symbol) {
            this.symbol = symbol;
        }

        public void visitIdentifier(IdentifierTree tree) {
            if (!this.used) {
                this.used = tree.symbol() == this.symbol;
            }
        }
    }

    private static class CollectionAndKey {
        private final Symbol collection;
        private final Tree keyTree;
        private final Object key;
        private final boolean isArray;
        private ExpressionTree rhs;

        private CollectionAndKey(Symbol collection, Tree keyTree, Object key, boolean isArray, @Nullable ExpressionTree expression) {
            this.collection = collection;
            this.keyTree = keyTree;
            this.key = key;
            this.isArray = isArray;
            this.rhs = expression;
        }

        private boolean collectionOnRHS() {
            FindSymbolUsage findSymbolUsage = new FindSymbolUsage(this.collection);
            this.rhs.accept((TreeVisitor)findSymbolUsage);
            return findSymbolUsage.used;
        }

        private String indexOrKey() {
            return this.isArray ? "index" : "key";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectionAndKey that = (CollectionAndKey)o;
            return Objects.equals(this.collection, that.collection) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.collection, this.key);
        }
    }
}

