/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.checks.serialization.SerializableContract;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="UnusedPrivateMethod")
@RspecKey(value="S1144")
public class UnusedPrivateMethodCheck
extends IssuableSubscriptionVisitor {
    private final List<MethodTree> unusedPrivateMethods = new ArrayList<MethodTree>();
    private final Set<String> unresolvedMethodNames = new HashSet<String>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR, Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD_REFERENCE, Tree.Kind.NEW_CLASS);
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.reportUnusedPrivateMethods();
        this.unusedPrivateMethods.clear();
        this.unresolvedMethodNames.clear();
    }

    private void reportUnusedPrivateMethods() {
        this.unusedPrivateMethods.stream().filter(methodTree -> !this.unresolvedMethodNames.contains(methodTree.simpleName().name())).forEach(methodTree -> {
            IdentifierTree simpleName = methodTree.simpleName();
            this.reportIssue((Tree)simpleName, String.format("Remove this unused private \"%s\" %s.", simpleName.name(), methodTree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) ? "constructor" : "method"));
        });
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        switch (tree.kind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                this.checkIfUnused((MethodTree)tree);
                break;
            }
            case NEW_CLASS: {
                this.checkIfUnknown((NewClassTree)tree);
                break;
            }
            case METHOD_INVOCATION: {
                this.checkIfUnknown((MethodInvocationTree)tree);
                break;
            }
            case METHOD_REFERENCE: {
                this.checkIfUnknown((MethodReferenceTree)tree);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected subscribed tree.");
            }
        }
    }

    private void checkIfUnknown(MethodInvocationTree mit) {
        if (mit.symbol().isUnknown()) {
            this.unresolvedMethodNames.add(ExpressionUtils.methodName((MethodInvocationTree)mit).name());
        }
    }

    private void checkIfUnknown(NewClassTree nct) {
        if (nct.constructorSymbol().isUnknown()) {
            this.unresolvedMethodNames.add(UnusedPrivateMethodCheck.constructorName(nct.identifier()));
        }
    }

    private void checkIfUnknown(MethodReferenceTree mref) {
        IdentifierTree methodIdentifier = mref.method();
        if (methodIdentifier.symbol().isUnknown()) {
            this.unresolvedMethodNames.add(methodIdentifier.name());
        }
    }

    private static String constructorName(TypeTree typeTree) {
        switch (typeTree.kind()) {
            case PARAMETERIZED_TYPE: {
                return UnusedPrivateMethodCheck.constructorName(((ParameterizedTypeTree)typeTree).type());
            }
            case MEMBER_SELECT: {
                return ((MemberSelectExpressionTree)typeTree).identifier().name();
            }
            case IDENTIFIER: {
                return ((IdentifierTree)typeTree).name();
            }
        }
        throw new IllegalStateException("Unexpected TypeTree used as constructor.");
    }

    private void checkIfUnused(MethodTree methodTree) {
        Symbol.MethodSymbol symbol = methodTree.symbol();
        if (UnusedPrivateMethodCheck.isUnusedPrivate((Symbol)symbol) && UnusedPrivateMethodCheck.hasNoAnnotation(methodTree) && (UnusedPrivateMethodCheck.isConstructorWithParameters(methodTree) || UnusedPrivateMethodCheck.isNotMethodFromSerializable(methodTree, (Symbol)symbol))) {
            this.unusedPrivateMethods.add(methodTree);
        }
    }

    private static boolean isUnusedPrivate(Symbol symbol) {
        return symbol.isPrivate() && symbol.usages().isEmpty();
    }

    private static boolean hasNoAnnotation(MethodTree methodTree) {
        return methodTree.modifiers().annotations().isEmpty();
    }

    private static boolean isConstructorWithParameters(MethodTree methodTree) {
        return methodTree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) && !methodTree.parameters().isEmpty();
    }

    private static boolean isNotMethodFromSerializable(MethodTree methodTree, Symbol symbol) {
        return methodTree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && !SerializableContract.SERIALIZABLE_CONTRACT_METHODS.contains(symbol.name());
    }
}

