/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5304")
public class EnvVariablesHotspotCheck
extends AbstractMethodDetection {
    private static final MethodMatcher RUNTIME_EXEC = MethodMatcher.create().typeDefinition("java.lang.Runtime").name("exec").withAnyParameters();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition("java.lang.System").name("getenv").withAnyParameters(), MethodMatcher.create().typeDefinition("java.lang.ProcessBuilder").name("environment").withoutParameter(), RUNTIME_EXEC);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!EnvVariablesHotspotCheck.isRuntimeExecWithoutSettingEnv(mit)) {
            this.reportIssue((Tree)mit, "Make sure that environment variables are used safely here.");
        }
    }

    private static boolean isRuntimeExecWithoutSettingEnv(MethodInvocationTree mit) {
        return RUNTIME_EXEC.matches(mit) && (mit.arguments().size() < 2 || ((ExpressionTree)mit.arguments().get(1)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}));
    }
}

