/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.MethodTree;

public final class UnitTestUtils {
    private static final Set<String> TEST_ANNOTATIONS = new HashSet<String>(Arrays.asList("org.junit.Test", "org.testng.annotations.Test"));
    private static final Set<String> JUNIT5_TEST_ANNOTATIONS = new HashSet<String>(Arrays.asList("org.junit.jupiter.api.Test", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.TestFactory", "org.junit.jupiter.api.TestTemplate", "org.junit.jupiter.params.ParameterizedTest"));

    private UnitTestUtils() {
    }

    public static boolean hasTestAnnotation(MethodTree tree) {
        SymbolMetadata symbolMetadata = tree.symbol().metadata();
        return TEST_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)symbolMetadata).isAnnotatedWith(arg_0)) || UnitTestUtils.hasJUnit5TestAnnotation(symbolMetadata);
    }

    public static boolean hasJUnit5TestAnnotation(MethodTree tree) {
        return UnitTestUtils.hasJUnit5TestAnnotation(tree.symbol().metadata());
    }

    private static boolean hasJUnit5TestAnnotation(SymbolMetadata symbolMetadata) {
        return JUNIT5_TEST_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)symbolMetadata).isAnnotatedWith(arg_0));
    }
}

