/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public final class ReassignmentFinder {
    private ReassignmentFinder() {
    }

    @CheckForNull
    public static ExpressionTree getClosestReassignmentOrDeclarationExpression(Tree startingPoint, Symbol referenceSymbol) {
        ExpressionTree initializerOrExpression;
        Tree result = referenceSymbol.declaration();
        List usages = referenceSymbol.usages();
        if (usages.size() != 1) {
            List<AssignmentExpressionTree> reassignments = ReassignmentFinder.getReassignments(referenceSymbol.owner().declaration(), usages);
            SyntaxToken startPointToken = startingPoint.firstToken();
            Tree lastReassignment = ReassignmentFinder.getClosestReassignment(startPointToken, reassignments);
            if (lastReassignment != null) {
                result = lastReassignment;
            }
        }
        if ((initializerOrExpression = ReassignmentFinder.getInitializerOrExpression(result)) == startingPoint) {
            return ReassignmentFinder.getClosestReassignmentOrDeclarationExpression(result, referenceSymbol);
        }
        return initializerOrExpression;
    }

    @CheckForNull
    public static ExpressionTree getInitializerOrExpression(@Nullable Tree tree) {
        if (tree == null) {
            return null;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return ((VariableTree)tree).initializer();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.ENUM_CONSTANT})) {
            return ((EnumConstantTree)tree).initializer();
        }
        return ((AssignmentExpressionTree)tree).expression();
    }

    public static List<AssignmentExpressionTree> getReassignments(@Nullable Tree ownerDeclaration, List<IdentifierTree> usages) {
        if (ownerDeclaration != null) {
            ArrayList<AssignmentExpressionTree> assignments = new ArrayList<AssignmentExpressionTree>();
            for (IdentifierTree usage : usages) {
                ReassignmentFinder.checkAssignment(usage).ifPresent(assignments::add);
            }
            return assignments;
        }
        return new ArrayList<AssignmentExpressionTree>();
    }

    private static Optional<AssignmentExpressionTree> checkAssignment(IdentifierTree usage) {
        AssignmentExpressionTree assignment;
        IdentifierTree previousTree = usage;
        Tree nonParenthesisParent = previousTree.parent();
        while (nonParenthesisParent.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            previousTree = nonParenthesisParent;
            nonParenthesisParent = previousTree.parent();
        }
        if (nonParenthesisParent instanceof AssignmentExpressionTree && (assignment = (AssignmentExpressionTree)nonParenthesisParent).variable().equals(previousTree)) {
            return Optional.of(assignment);
        }
        return Optional.empty();
    }

    @CheckForNull
    private static Tree getClosestReassignment(SyntaxToken startToken, List<AssignmentExpressionTree> reassignments) {
        Tree result = null;
        List assignmentsBeforeStartToken = reassignments.stream().sorted(ReassignmentFinder::isBefore).filter(a -> ReassignmentFinder.isBefore((Tree)startToken, (Tree)a) > 0).collect(Collectors.toList());
        if (!assignmentsBeforeStartToken.isEmpty()) {
            return (Tree)assignmentsBeforeStartToken.get(assignmentsBeforeStartToken.size() - 1);
        }
        return result;
    }

    private static int isBefore(Tree t1, Tree t2) {
        SyntaxToken firstTokenT1 = t1.firstToken();
        SyntaxToken firstTokenT2 = t2.firstToken();
        int line = Integer.compare(firstTokenT1.line(), firstTokenT2.line());
        return line != 0 ? line : Integer.compare(firstTokenT1.column(), firstTokenT2.column());
    }
}

