/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2065")
public class TransientFieldInNonSerializableCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (this.hasSemantic() && TransientFieldInNonSerializableCheck.isNotSerializable(classTree.symbol())) {
            for (Tree member : classTree.members()) {
                ModifierKeywordTree transientModifier = TransientFieldInNonSerializableCheck.isTransient(member);
                if (transientModifier == null) continue;
                this.reportIssue((Tree)transientModifier, "Remove the \"transient\" modifier from this field.");
            }
        }
    }

    private static boolean isNotSerializable(Symbol.TypeSymbol symbol) {
        for (Type superType : ((JavaSymbol.TypeJavaSymbol)symbol).superTypes()) {
            if (!superType.isUnknown()) continue;
            return false;
        }
        return !symbol.type().isSubtypeOf("java.io.Serializable");
    }

    private static ModifierKeywordTree isTransient(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variable = (VariableTree)tree;
            return ModifiersUtils.getModifier((ModifiersTree)variable.modifiers(), (Modifier)Modifier.TRANSIENT);
        }
        return null;
    }
}

