/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.java.ast.visitors.LinesOfCodeVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00104")
@RspecKey(value="S104")
public class TooManyLinesOfCodeInFileCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAXIMUM = 750;
    @RuleProperty(key="Max", description="Maximum authorized lines in a file.", defaultValue="750")
    public int maximum = 750;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        int lines = new LinesOfCodeVisitor().linesOfCode(tree);
        if (lines > this.maximum) {
            this.addIssueOnFile(MessageFormat.format("This file has {0} lines, which is greater than {1} authorized. Split it into smaller files.", lines, this.maximum));
        }
    }
}

