/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S3020")
public class ToArrayCheck
extends AbstractMethodDetection {
    private static final MethodMatcher COLLECTION_TO_ARRAY = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.util.Collection")).name("toArray").withoutParameter();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(COLLECTION_TO_ARRAY);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Tree parent = mit.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
            this.checkCast(((TypeCastTree)parent).symbolType(), mit);
        }
    }

    private void checkCast(Type type, MethodInvocationTree mit) {
        Type elementType;
        if (type.isArray() && !type.is("java.lang.Object[]") && !((JavaType)(elementType = ((Type.ArrayType)type).elementType())).isTagged(15)) {
            this.reportIssue((Tree)mit, "Pass \"new " + elementType.name() + "[0]\" as argument to \"toArray\".");
        }
    }
}

