/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.resolve.Flags;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3551")
public class SynchronizedOverrideCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make this method \"synchronized\" to match the parent class implementation.";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        Symbol.MethodSymbol overriddenSymbol = methodSymbol.overriddenSymbol();
        if (overriddenSymbol == null || overriddenSymbol.isUnknown()) {
            return;
        }
        if (SynchronizedOverrideCheck.isSynchronized((Symbol)overriddenSymbol) && !SynchronizedOverrideCheck.isSynchronized((Symbol)methodSymbol)) {
            List<Object> secondaries = Collections.emptyList();
            MethodTree overridenMethodTree = overriddenSymbol.declaration();
            if (overridenMethodTree != null) {
                secondaries = Collections.singletonList(new JavaFileScannerContext.Location("", (Tree)overridenMethodTree.simpleName()));
            }
            this.reportIssue((Tree)methodTree.simpleName(), MESSAGE, secondaries, null);
        }
    }

    private static boolean isSynchronized(Symbol methodSymbol) {
        return Flags.isFlagged((int)((JavaSymbol)methodSymbol).flags(), (int)32);
    }
}

