/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4530")
public class Struts1EndpointCheck
extends IssuableSubscriptionVisitor {
    private static final String[] args1 = new String[]{"org.apache.struts.action.ActionMapping", "org.apache.struts.action.ActionForm", "javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse"};
    private static final String[] args2 = new String[]{"org.apache.struts.action.ActionMapping", "org.apache.struts.action.ActionForm", "javax.servlet.ServletRequest", "javax.servlet.ServletResponse"};
    private static final MethodMatcherCollection STRUTS_METHOD = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("perform").parameters(args1), MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("perform").parameters(args2), MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("execute").parameters(args1), MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("execute").parameters(args2)});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        List actionMappingUsages;
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        if (methodTree.symbol().owner().type().isSubtypeOf("org.apache.struts.action.Action") && STRUTS_METHOD.anyMatch(methodTree) && !(actionMappingUsages = ((VariableTree)methodTree.parameters().get(1)).symbol().usages()).isEmpty()) {
            this.reportIssue((Tree)methodTree.simpleName(), "Make sure that the ActionForm is used safely here.", actionMappingUsages.stream().map(idTree -> new JavaFileScannerContext.Location("", (Tree)idTree)).collect(Collectors.toList()), null);
        }
    }
}

