/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5361")
public class StringReplaceCheck
extends AbstractMethodDetection {
    private static final String LANG_STRING = "java.lang.String";
    private static final char[] REGEX_META = ".$|([{^?*+\\".toCharArray();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().typeDefinition(LANG_STRING).name("replaceAll").addParameter(LANG_STRING).addParameter(LANG_STRING));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree regexArg = (ExpressionTree)mit.arguments().get(0);
        String regexValue = ConstantUtils.resolveAsStringConstant(regexArg);
        if (regexValue != null && !StringReplaceCheck.isRegex(regexValue)) {
            this.reportIssue((Tree)((MemberSelectExpressionTree)mit.methodSelect()).identifier(), "Replace this call to \"replaceAll()\" by a call to the \"replace()\" method.");
        }
    }

    private static boolean isRegex(String s) {
        for (char c : s.toCharArray()) {
            for (char meta : REGEX_META) {
                if (c != meta) continue;
                return true;
            }
        }
        return false;
    }
}

