/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3252")
public class StaticMemberAccessCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcherCollection LIST_SET_OF = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.util.List").name("of").withAnyParameters(), MethodMatcher.create().typeDefinition("java.util.Set").name("of").withAnyParameters()});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.MEMBER_SELECT);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MemberSelectExpressionTree mse = (MemberSelectExpressionTree)tree;
        Symbol symbol = mse.identifier().symbol();
        if (symbol.isStatic() && !StaticMemberAccessCheck.isListOrSetOf(mse)) {
            ExpressionTree expression = mse.expression();
            Type staticType = symbol.owner().type();
            if (!expression.symbolType().equals(staticType)) {
                this.reportIssue((Tree)mse.identifier(), String.format("Use static access with \"%s\" for \"%s\".", staticType.fullyQualifiedName(), symbol.name()));
            }
        }
    }

    private static boolean isListOrSetOf(MemberSelectExpressionTree mse) {
        Tree parent = mse.parent();
        return parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && LIST_SET_OF.anyMatch((MethodInvocationTree)parent);
    }
}

