/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1656")
public class SelfAssignementCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        AssignmentExpressionTree node = (AssignmentExpressionTree)tree;
        if (SyntacticEquivalence.areEquivalent((Tree)node.expression(), (Tree)node.variable())) {
            this.reportIssue((Tree)node.operatorToken(), "Remove or correct this useless self-assignment.");
        }
    }
}

