/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;

@Rule(key="S1228")
public class PackageInfoCheck
implements JavaFileScanner {
    Set<File> directoriesWithoutPackageFile = new HashSet<File>();

    public void scanFile(JavaFileScannerContext context) {
        File parentFile = context.getInputFile().file().getParentFile();
        if (!new File(parentFile, "package-info.java").isFile() && !this.directoriesWithoutPackageFile.contains(parentFile)) {
            Path baseDirAbsolutePath = ((DefaultJavaFileScannerContext)context).getBaseDirectory().getAbsoluteFile().toPath();
            Path parentDirAbsolutePath = parentFile.getAbsoluteFile().toPath();
            Path relativize = baseDirAbsolutePath.relativize(parentDirAbsolutePath);
            context.addIssueOnProject((JavaCheck)this, "Add a 'package-info.java' file to document the '" + relativize.toString() + "' package");
            this.directoriesWithoutPackageFile.add(parentFile);
        }
    }
}

