/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2118")
public class NonSerializableWriteCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcher WRITE_OBJECT_MATCHER = MethodMatcher.create().typeDefinition("java.io.ObjectOutputStream").name("writeObject").addParameter("java.lang.Object");
    private final List<Symbol> testedSymbols = new ArrayList<Symbol>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.INSTANCE_OF);
    }

    public void setContext(JavaFileScannerContext context) {
        this.testedSymbols.clear();
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.visitMethodInvocation((MethodInvocationTree)tree);
            } else {
                this.visitInstanceOf((InstanceOfTree)tree);
            }
        }
    }

    private void visitInstanceOf(InstanceOfTree instanceOfTree) {
        ExpressionTree expression = instanceOfTree.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && instanceOfTree.type().symbolType().is("java.io.Serializable")) {
            this.testedSymbols.add(((IdentifierTree)expression).symbol());
        }
    }

    private boolean isTestedSymbol(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol symbol = ((IdentifierTree)tree).symbol();
            return this.testedSymbols.contains(symbol);
        }
        return false;
    }

    private void visitMethodInvocation(MethodInvocationTree methodInvocation) {
        ExpressionTree argument;
        if (WRITE_OBJECT_MATCHER.matches(methodInvocation) && !NonSerializableWriteCheck.isAcceptableType((argument = (ExpressionTree)methodInvocation.arguments().get(0)).symbolType()) && !this.isTestedSymbol(argument) && !NonSerializableWriteCheck.hasSerializableConcreteType(argument)) {
            this.reportIssue((Tree)argument, "Make the \"" + argument.symbolType().fullyQualifiedName() + "\" class \"Serializable\" or don't write it.");
        }
    }

    private static boolean hasSerializableConcreteType(ExpressionTree argument) {
        if (argument.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree argument1 = (IdentifierTree)argument;
            Tree declaration = argument1.symbol().declaration();
            if (argument1.symbol().isFinal() && declaration != null && declaration.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                ExpressionTree initializer = ((VariableTree)declaration).initializer();
                return initializer != null && NonSerializableWriteCheck.isAcceptableType(initializer.symbolType());
            }
        }
        return false;
    }

    private static boolean isAcceptableType(Type argType) {
        return argType.isSubtypeOf("java.io.Serializable") || argType.is("java.lang.Object") || argType.isPrimitive() || !argType.isClass();
    }
}

