/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S4517")
public class InputStreamReadCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcher INPUT_STREAM_READ = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.io.InputStream")).name("read").withoutParameter();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree method = (MethodTree)tree;
        if (method.block() != null && INPUT_STREAM_READ.matches(method)) {
            method.accept((TreeVisitor)new ReturnStatementVisitor());
        }
    }

    private class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private ReturnStatementVisitor() {
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            ExpressionTree expression = tree.expression();
            if (expression.symbolType().is("byte")) {
                InputStreamReadCheck.this.reportIssue((Tree)expression, "Convert this signed byte into an unsigned byte.");
            }
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

