/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2692")
public class IndexOfWithPositiveNumberCheck
extends IssuableSubscriptionVisitor {
    private static final String INDEXOF = "indexOf";
    private static final MethodMatcherCollection CHECKED_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition(String.class.getName()).name("indexOf").addParameter("int"), MethodMatcher.create().typeDefinition(String.class.getName()).name("indexOf").addParameter(String.class.getName()), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.util.List")).name("indexOf").addParameter("java.lang.Object")});

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree binaryTree = (BinaryExpressionTree)tree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN})) {
            this.checkForIssue(tree, binaryTree.leftOperand(), LiteralUtils.longLiteralValue((ExpressionTree)binaryTree.rightOperand()));
        } else {
            this.checkForIssue(tree, binaryTree.rightOperand(), LiteralUtils.longLiteralValue((ExpressionTree)binaryTree.leftOperand()));
        }
    }

    private void checkForIssue(Tree tree, ExpressionTree operand, @Nullable Long constant) {
        if (constant != null && constant == 0L && IndexOfWithPositiveNumberCheck.isIndexOfOnArrayOrString((Tree)operand)) {
            this.reportIssue(tree, "0 is a valid index, but is ignored by this check.");
        }
    }

    private static boolean isIndexOfOnArrayOrString(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && CHECKED_METHODS.anyMatch((MethodInvocationTree)tree);
    }
}

