/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4551")
public class EnumEqualCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().name("equals").parameters(new String[]{"java.lang.Object"}));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MemberSelectExpressionTree mse;
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (EnumEqualCheck.isEnum((mse = (MemberSelectExpressionTree)mit.methodSelect()).expression()) || EnumEqualCheck.isEnum((ExpressionTree)mit.arguments().get(0)))) {
            this.reportIssue((Tree)mse.identifier(), "Use \"==\" to perform this enum comparison instead of using \"equals\"");
        }
    }

    private static boolean isEnum(ExpressionTree exp) {
        return exp.symbolType().symbol().isEnum();
    }
}

