/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2203")
public class CollectInsteadOfForeachCheck
extends AbstractMethodDetection {
    private static final TypeCriteria SUBTYPE_OF_LIST = TypeCriteria.subtypeOf((String)"java.util.List");
    private static final MethodMatcher FOREACH = MethodMatcher.create().typeDefinition("java.util.stream.Stream").name("forEach").withAnyParameters();
    private static final MethodMatcher ADD = MethodMatcher.create().typeDefinition(SUBTYPE_OF_LIST).name("add").withAnyParameters();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(FOREACH);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree firstArgument = (ExpressionTree)mit.arguments().get(0);
        if (firstArgument.is(new Tree.Kind[]{Tree.Kind.METHOD_REFERENCE})) {
            this.handleMethodReference((MethodReferenceTree)firstArgument);
        } else if (firstArgument.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION})) {
            this.handleLambdaExpression((LambdaExpressionTree)firstArgument);
        }
    }

    private void handleMethodReference(MethodReferenceTree methodRef) {
        Tree expression = methodRef.expression();
        if (ADD.matches(methodRef.method().symbol())) {
            this.checkExpression((Tree)methodRef, expression);
        }
    }

    private void handleLambdaExpression(LambdaExpressionTree lambda) {
        ExpressionTree methodSelect;
        MethodInvocationTree mit;
        Tree expr = lambda.body();
        if (expr.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            expr = CollectInsteadOfForeachCheck.expressionFromSingleStatementBlock(((BlockTree)expr).body());
        }
        if (expr != null && expr.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && ADD.matches(mit = (MethodInvocationTree)expr) && (methodSelect = mit.methodSelect()).is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.checkExpression((Tree)lambda, (Tree)((MemberSelectExpressionTree)methodSelect).expression());
        }
    }

    @CheckForNull
    private static ExpressionTree expressionFromSingleStatementBlock(List<StatementTree> body) {
        if (body.size() == 1) {
            StatementTree singleStatement = body.get(0);
            if (singleStatement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
                return ((ExpressionStatementTree)singleStatement).expression();
            }
        }
        return null;
    }

    private void checkExpression(Tree reportTree, Tree expression) {
        Optional<Object> listName = Optional.empty();
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            listName = Optional.of(((IdentifierTree)expression).name());
        } else if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            listName = Optional.of(((MemberSelectExpressionTree)expression).identifier().name());
        }
        listName.ifPresent(list -> this.context.reportIssue((JavaCheck)this, reportTree, CollectInsteadOfForeachCheck.getMessage(reportTree, list)));
    }

    private static String getMessage(Tree reportTree, String listName) {
        String msg = reportTree.is(new Tree.Kind[]{Tree.Kind.METHOD_REFERENCE}) ? "Use \"collect(Collectors.toList())\" instead of \"forEach(%s::add)\"." : "Use \"collect(Collectors.toList())\" instead of adding elements in \"%s\" using \"forEach(...)\".";
        return String.format(msg, listName);
    }
}

