/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2141")
public class ClassWithoutHashCodeInHashStructureCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcher EQUALS_MATCHER = MethodMatcher.create().name("equals").parameters(new String[]{"java.lang.Object"});
    private static final MethodMatcher HASHCODE_MATCHER = MethodMatcher.create().name("hashCode").withoutParameter();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        ParametrizedTypeJavaType ptt;
        Symbol.TypeSymbol symbol;
        if (!this.hasSemantic()) {
            return;
        }
        Type type = ((NewClassTree)tree).symbolType();
        if (type instanceof ParametrizedTypeJavaType && ClassWithoutHashCodeInHashStructureCheck.useHashDataStructure(type) && ClassWithoutHashCodeInHashStructureCheck.implementsEquals(symbol = (ptt = (ParametrizedTypeJavaType)type).substitution((TypeVariableJavaType)ptt.typeParameters().get(0)).symbol()) && !ClassWithoutHashCodeInHashStructureCheck.implementsHashCode(symbol)) {
            this.reportIssue(tree, "Add a \"hashCode()\" method to \"" + symbol.name() + "\" or remove it from this hash.");
        }
    }

    private static boolean useHashDataStructure(Type type) {
        return type.isSubtypeOf("java.util.HashMap") || type.isSubtypeOf("java.util.HashSet") || type.isSubtypeOf("java.util.Hashtable");
    }

    private static boolean implementsEquals(Symbol.TypeSymbol symbol) {
        return symbol.lookupSymbols("equals").stream().anyMatch(arg_0 -> ((MethodMatcher)EQUALS_MATCHER).matches(arg_0));
    }

    private static boolean implementsHashCode(Symbol.TypeSymbol symbol) {
        return symbol.lookupSymbols("hashCode").stream().anyMatch(arg_0 -> ((MethodMatcher)HASHCODE_MATCHER).matches(arg_0));
    }
}

