/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2188")
public class CallSuperInTestCaseCheck
extends IssuableSubscriptionVisitor {
    public static final String JUNIT_FRAMEWORK_TEST_CASE = "junit.framework.TestCase";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        boolean isMethodInJunit3;
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        boolean bl = isMethodInJunit3 = CallSuperInTestCaseCheck.isWithinJunit3TestCase(methodSymbol) && CallSuperInTestCaseCheck.isSetUpOrTearDown(methodSymbol);
        if (isMethodInJunit3 && CallSuperInTestCaseCheck.requiresSuperCall(methodSymbol) && !CallSuperInTestCaseCheck.callSuperOnOverride(methodTree.block(), methodSymbol)) {
            this.reportIssue((Tree)methodTree.simpleName(), String.format("Add a \"super.%s()\" call to this method.", methodSymbol.name()));
        }
    }

    private static boolean requiresSuperCall(Symbol.MethodSymbol methodSymbol) {
        Type superType = methodSymbol.owner().type().symbol().superClass();
        Collection symbols = new ArrayList();
        while (superType != null && !superType.is(JUNIT_FRAMEWORK_TEST_CASE) && symbols.isEmpty()) {
            symbols = superType.symbol().lookupSymbols(methodSymbol.name());
            superType = superType.symbol().superClass();
        }
        return !symbols.isEmpty() && !((Symbol)symbols.iterator().next()).owner().type().is(JUNIT_FRAMEWORK_TEST_CASE);
    }

    private static boolean callSuperOnOverride(@Nullable BlockTree block, Symbol.MethodSymbol methodSymbol) {
        if (block == null) {
            return false;
        }
        InvocationVisitor visitor = new InvocationVisitor(methodSymbol.name());
        block.accept((TreeVisitor)visitor);
        return visitor.superCallOnOverride;
    }

    private static boolean isWithinJunit3TestCase(Symbol.MethodSymbol methodSymbol) {
        Type type = methodSymbol.owner().type();
        return type.isSubtypeOf(JUNIT_FRAMEWORK_TEST_CASE) && !type.symbol().superClass().is(JUNIT_FRAMEWORK_TEST_CASE);
    }

    private static boolean isSetUpOrTearDown(Symbol.MethodSymbol methodSymbol) {
        return ("setUp".equals(methodSymbol.name()) || "tearDown".equals(methodSymbol.name())) && methodSymbol.parameterTypes().isEmpty();
    }

    private static class InvocationVisitor
    extends BaseTreeVisitor {
        private final String methodName;
        private boolean superCallOnOverride = false;

        InvocationVisitor(String methodName) {
            this.methodName = methodName;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            MemberSelectExpressionTree mse;
            if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (mse = (MemberSelectExpressionTree)tree.methodSelect()).expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "super".equals(((IdentifierTree)mse.expression()).name()) && mse.identifier().name().equals(this.methodName)) {
                this.superCallOnOverride |= !((IdentifierTree)mse.expression()).symbol().type().is(CallSuperInTestCaseCheck.JUNIT_FRAMEWORK_TEST_CASE);
            }
            super.visitMethodInvocation(tree);
        }
    }
}

