/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.PropertyField;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.utils.Preconditions;

public final class PropertyFieldDefinition {
    private final String key;
    private final String name;
    private final String description;
    private final PropertyType type;
    private final List<String> options;

    private PropertyFieldDefinition(Builder builder) {
        this.key = builder.key;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.options = builder.options;
    }

    static List<PropertyFieldDefinition> create(PropertyField[] fields) {
        ArrayList<PropertyFieldDefinition> definitions = new ArrayList<PropertyFieldDefinition>();
        for (PropertyField field : fields) {
            definitions.add(PropertyFieldDefinition.build(field.key()).name(field.name()).description(field.description()).type(field.type()).options(field.options()).build());
        }
        return definitions;
    }

    public static Builder build(String key) {
        return new Builder(key);
    }

    public String key() {
        return this.key;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public PropertyType type() {
        return this.type;
    }

    public List<String> options() {
        return this.options;
    }

    public PropertyDefinition.Result validate(@Nullable String value) {
        return PropertyDefinition.validate(this.type, value, this.options);
    }

    public static class Builder {
        private String key;
        private String name;
        private String description;
        private PropertyType type;
        private List<String> options;

        private Builder(String key) {
            this.key = key;
            this.name = "";
            this.description = "";
            this.type = PropertyType.STRING;
            this.options = new ArrayList<String>();
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder type(PropertyType type) {
            this.type = type;
            return this;
        }

        public Builder options(String ... options) {
            this.options.addAll(Arrays.asList(options));
            return this;
        }

        public Builder options(List<String> options) {
            this.options.addAll(options);
            return this;
        }

        public PropertyFieldDefinition build() {
            Preconditions.checkArgument(!StringUtils.isEmpty(this.key), "Key must be set");
            Preconditions.checkArgument(!StringUtils.isEmpty(this.name), "Name must be set");
            return new PropertyFieldDefinition(this);
        }
    }
}

