/*
 * Decompiled with CFR 0.152.
 */
package com.sonarsource.checks.verifier.internal;

import com.sonarsource.checks.verifier.FileContent;
import com.sonarsource.checks.verifier.internal.Comment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class TestFile
extends FileContent {
    private final Map<Integer, List<Comment>> commentListPreLineMap = new HashMap<Integer, List<Comment>>();
    private final String lineNumberPrefixFormat;

    TestFile(FileContent file) {
        super(file.getPath(), file.getContent());
        int maxLineNumberLength = String.valueOf(file.getLines().length).length();
        this.lineNumberPrefixFormat = "%0" + Math.max(3, maxLineNumberLength) + "d: ";
    }

    String linePrefix(int lineNumber) {
        return String.format(this.lineNumberPrefixFormat, lineNumber);
    }

    void addNoncompliantComment(Comment comment) {
        if (!comment.path.equals(this.getPath())) {
            throw new IllegalStateException("This comment is not related to file '" + this.getPath() + "' but '" + comment.path + "'");
        }
        this.commentListPreLineMap.computeIfAbsent(comment.line, key -> new ArrayList()).add(comment);
    }

    String line(int lineNumber) {
        if (lineNumber < 1 || lineNumber > this.getLines().length) {
            throw new IllegalStateException("No line " + lineNumber + " in " + this.getName());
        }
        return this.getLines()[lineNumber - 1];
    }

    String lineWithoutNoncompliantComment(int line) {
        String code = this.line(line);
        List<Comment> comments = this.commentListPreLineMap.get(line);
        if (comments != null) {
            for (Comment comment : comments) {
                code = TestFile.hideComment(code, comment);
            }
        }
        return code.replace('\t', '\u279e');
    }

    private static String hideComment(String code, Comment comment) {
        if (comment.column - 1 < code.length()) {
            int end;
            for (end = comment.column - 1; end > 0 && code.charAt(end - 1) == ' '; --end) {
            }
            return code.substring(0, end);
        }
        return code;
    }

    @Nullable
    String commentAt(int line) {
        List<Comment> comments = this.commentListPreLineMap.get(line);
        if (comments != null && !comments.isEmpty()) {
            return this.line(line).substring(comments.get((int)0).column - 1);
        }
        return null;
    }
}

