/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.os.Bundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.solovyev.android.checkout.Billing;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.Purchase;
import org.solovyev.android.checkout.PurchaseComparator;

@Immutable
public final class Purchases {
    static final String BUNDLE_DATA_LIST = "INAPP_PURCHASE_DATA_LIST";
    static final String BUNDLE_SIGNATURE_LIST = "INAPP_DATA_SIGNATURE_LIST";
    static final String BUNDLE_CONTINUATION_TOKEN = "INAPP_CONTINUATION_TOKEN";
    @Nonnull
    public final String product;
    @Nonnull
    public final List<Purchase> list;
    @Nullable
    public final String continuationToken;

    Purchases(@Nonnull String product, @Nonnull List<Purchase> list, @Nullable String continuationToken) {
        this.product = product;
        this.list = Collections.unmodifiableList(list);
        this.continuationToken = continuationToken;
    }

    @Nonnull
    static Purchases fromBundle(@Nonnull Bundle bundle, @Nonnull String product) throws JSONException {
        String continuationToken = Purchases.getContinuationTokenFromBundle(bundle);
        List<Purchase> purchases = Purchases.getListFromBundle(bundle);
        return new Purchases(product, purchases, continuationToken);
    }

    @Nullable
    static String getContinuationTokenFromBundle(@Nonnull Bundle bundle) {
        return bundle.getString(BUNDLE_CONTINUATION_TOKEN);
    }

    @Nonnull
    static List<Purchase> getListFromBundle(@Nonnull Bundle bundle) throws JSONException {
        List<String> datas = Purchases.extractDatasList(bundle);
        ArrayList signatures = bundle.getStringArrayList(BUNDLE_SIGNATURE_LIST);
        ArrayList<Purchase> purchases = new ArrayList<Purchase>(datas.size());
        for (int i = 0; i < datas.size(); ++i) {
            String data = datas.get(i);
            String signature = signatures != null ? (String)signatures.get(i) : "";
            purchases.add(Purchase.fromJson(data, signature));
        }
        return purchases;
    }

    @Nonnull
    private static List<String> extractDatasList(@Nonnull Bundle bundle) {
        ArrayList list = bundle.getStringArrayList(BUNDLE_DATA_LIST);
        return list != null ? list : Collections.emptyList();
    }

    @Nullable
    static Purchase getPurchaseInState(@Nonnull List<Purchase> purchases, @Nonnull String sku, @Nonnull Purchase.State state) {
        for (Purchase purchase : purchases) {
            if (!purchase.sku.equals(sku) || purchase.state != state) continue;
            return purchase;
        }
        return null;
    }

    @Nonnull
    static List<Purchase> neutralize(@Nonnull List<Purchase> purchases) {
        purchases = new LinkedList<Purchase>(purchases);
        ArrayList<Purchase> result = new ArrayList<Purchase>(purchases.size());
        Collections.sort(purchases, PurchaseComparator.earliestFirst());
        while (!purchases.isEmpty()) {
            Purchase purchase = purchases.get(0);
            switch (purchase.state) {
                case PURCHASED: {
                    if (Purchases.isNeutralized(purchases, purchase)) break;
                    result.add(purchase);
                    break;
                }
                case CANCELLED: 
                case REFUNDED: 
                case EXPIRED: {
                    if (Purchases.isDangling(purchases, purchase)) break;
                    result.add(purchase);
                }
            }
            purchases.remove(0);
        }
        Collections.reverse(result);
        return result;
    }

    private static boolean isDangling(@Nonnull List<Purchase> purchases, @Nonnull Purchase purchase) {
        Check.isFalse(purchase.state == Purchase.State.PURCHASED, "Must not be PURCHASED");
        for (int i = 1; i < purchases.size(); ++i) {
            Purchase same = purchases.get(i);
            if (!same.sku.equals(purchase.sku)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNeutralized(@Nonnull List<Purchase> purchases, @Nonnull Purchase purchase) {
        Check.isTrue(purchase.state == Purchase.State.PURCHASED, "Must be PURCHASED");
        for (int i = 1; i < purchases.size(); ++i) {
            Purchase same = purchases.get(i);
            if (!same.sku.equals(purchase.sku)) continue;
            switch (same.state) {
                case PURCHASED: {
                    Billing.warning("Two purchases with same SKU found: " + purchase + " and " + same);
                    break;
                }
                case CANCELLED: 
                case REFUNDED: 
                case EXPIRED: {
                    purchases.remove(i);
                }
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public String toJson() {
        return this.toJson(false);
    }

    @Nonnull
    public String toJson(boolean withSignatures) {
        return this.toJsonObject(withSignatures).toString();
    }

    @Nonnull
    JSONObject toJsonObject(boolean withSignatures) {
        JSONObject json = new JSONObject();
        try {
            json.put("product", (Object)this.product);
            JSONArray array = new JSONArray();
            for (int i = 0; i < this.list.size(); ++i) {
                Purchase purchase = this.list.get(i);
                array.put(i, (Object)purchase.toJsonObject(withSignatures));
            }
            json.put("list", (Object)array);
        }
        catch (JSONException e) {
            throw new AssertionError((Object)e);
        }
        return json;
    }

    @Nullable
    public Purchase getPurchase(@Nonnull String sku) {
        for (Purchase purchase : this.list) {
            if (!purchase.sku.equals(sku)) continue;
            return purchase;
        }
        return null;
    }

    public boolean hasPurchase(@Nonnull String sku) {
        return this.getPurchase(sku) != null;
    }

    public boolean hasPurchaseInState(@Nonnull String sku, @Nonnull Purchase.State state) {
        return this.getPurchaseInState(sku, state) != null;
    }

    @Nullable
    public Purchase getPurchaseInState(@Nonnull String sku, @Nonnull Purchase.State state) {
        return Purchases.getPurchaseInState(this.list, sku, state);
    }
}

