/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.app.PendingIntent;
import android.os.Bundle;
import android.os.RemoteException;
import com.android.vending.billing.InAppBillingService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.Request;
import org.solovyev.android.checkout.RequestException;
import org.solovyev.android.checkout.RequestType;

final class ChangePurchaseRequest
extends Request<PendingIntent> {
    @Nonnull
    private final String mProduct;
    @Nonnull
    private final List<String> mOldSkus;
    @Nonnull
    private final String mNewSku;
    @Nullable
    private final String mPayload;

    ChangePurchaseRequest(@Nonnull String product, @Nonnull List<String> oldSkus, @Nonnull String newSku, @Nullable String payload) {
        super(RequestType.CHANGE_PURCHASE, 5);
        Check.isTrue(!oldSkus.isEmpty(), "There must be at least one old SKU to be changed");
        this.mProduct = product;
        this.mOldSkus = new ArrayList<String>(oldSkus);
        this.mNewSku = newSku;
        this.mPayload = payload;
    }

    @Override
    void start(@Nonnull InAppBillingService service, @Nonnull String packageName) throws RemoteException, RequestException {
        Bundle bundle = service.getBuyIntentToReplaceSkus(this.mApiVersion, packageName, this.mOldSkus, this.mNewSku, this.mProduct, this.mPayload == null ? "" : this.mPayload);
        if (this.handleError(bundle)) {
            return;
        }
        PendingIntent pendingIntent = (PendingIntent)bundle.getParcelable("BUY_INTENT");
        Check.isNotNull(pendingIntent);
        this.onSuccess(pendingIntent);
    }

    @Override
    @Nullable
    protected String getCacheKey() {
        return null;
    }
}

