/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.jms;

import javax.jms.Message;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.transport.PropertyScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsExpressionEvaluator
implements ExpressionEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsExpressionEvaluator.class);
    protected String evaluatorName = "jms";
    public static final String EXPR_IS_EXHAUSTED = "isExhausted";
    public static final String EXPR_IS_REDELIVERY = "isRedelivery";
    protected int maxRedeliveries;

    public Object evaluate(String expression, MuleMessage message) {
        String jmsMessageId;
        Integer deliveryCount;
        Object object = null;
        if (message.getOriginalPayload() != null && message.getOriginalPayload() instanceof Message) {
            try {
                deliveryCount = ((Message)message.getOriginalPayload()).getIntProperty("JMSXDeliveryCount");
                jmsMessageId = ((Message)message.getOriginalPayload()).getStringProperty("JMSMessageID");
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to evaluate JMS message. Expression evaluator: " + expression, e);
            }
        } else {
            deliveryCount = (Integer)message.getProperty("JMSXDeliveryCount", PropertyScope.INVOCATION);
            jmsMessageId = (String)message.getProperty("JMSMessageID", PropertyScope.INVOCATION);
            if (deliveryCount == null || jmsMessageId == null) {
                throw new RuntimeException("Failed to evaluate JMS message. Expression evaluator: " + expression);
            }
        }
        LOGGER.debug("JMSMessageID: {}, JMSXDeliveryCount: {}", (Object)jmsMessageId, (Object)deliveryCount);
        if (EXPR_IS_EXHAUSTED.equals(expression)) {
            if (this.maxRedeliveries < deliveryCount) {
                LOGGER.warn("Exhausted! JMSMessageID: {}, JMSXDeliveryCount: {}", (Object)jmsMessageId, (Object)deliveryCount);
                return true;
            }
            return false;
        }
        if (EXPR_IS_REDELIVERY.equals(expression)) {
            if (deliveryCount == 1) {
                return false;
            }
            return true;
        }
        return object;
    }

    public int getMaxRedeliveries() {
        return this.maxRedeliveries;
    }

    public void setMaxRedeliveries(int maxRedeliveries) {
        this.maxRedeliveries = maxRedeliveries;
    }

    public String getName() {
        return this.evaluatorName;
    }

    public void setName(String name) {
        this.evaluatorName = name;
    }
}

