/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.soap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixCxfEncodingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger log = LoggerFactory.getLogger(FixCxfEncodingInterceptor.class);

    public FixCxfEncodingInterceptor() {
        super("prepare-send");
        this.addBefore(MessageSenderInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        String ct;
        HashMap headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (headers == null) {
            headers = new HashMap();
            message.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        if ((ct = "text/xml;charset=UTF-8;") != null) {
            ArrayList<String> contentType = new ArrayList<String>();
            contentType.add(ct);
            headers.put(HttpHeaderHelper.getHeaderKey((String)"Content-Type"), contentType);
            message.put((Object)"Content-Type", (Object)ct);
            log.debug("### Added content-type: {}", (Object)ct);
        }
    }
}

