/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.jaxb;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.soitoolkit.commons.mule.jaxb.JaxbUtil;

public abstract class AbstractJaxbTransformer
extends AbstractMessageAwareTransformer {
    private String contextPath = null;
    private JaxbUtil jaxbUtil = null;
    private static Map<String, JaxbUtil> jaxbUtilMap = new HashMap<String, JaxbUtil>();

    public void initialise() throws InitialisationException {
        try {
            this.initializeCachedJaxbObject();
        }
        catch (JAXBException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCachedJaxbObject() throws JAXBException {
        String transformerName = this.getName();
        JaxbUtil cachedJaxbContex = jaxbUtilMap.get(transformerName);
        if (cachedJaxbContex != null) {
            this.jaxbUtil = cachedJaxbContex;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Use cached JaxbUtil for transformer " + transformerName));
            }
            return;
        }
        Map<String, JaxbUtil> map = jaxbUtilMap;
        synchronized (map) {
            cachedJaxbContex = jaxbUtilMap.get(transformerName);
            if (cachedJaxbContex != null) {
                this.jaxbUtil = cachedJaxbContex;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Use cached JaxbUtil for transformer (created during wait for lock!) " + transformerName));
                }
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Load JaxbUtil for " + this.getName() + " based on context path: " + this.contextPath));
            }
            this.jaxbUtil = new JaxbUtil(this.contextPath);
            jaxbUtilMap.put(transformerName, this.jaxbUtil);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = this.trimWhitespace(contextPath);
    }

    protected JaxbUtil getJaxbUtil() {
        if (this.jaxbUtil == null) {
            try {
                this.logger.debug((Object)"null jaxbutil detected, calling initializeCachedJaxbObject()!");
                this.initializeCachedJaxbObject();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.jaxbUtil;
    }

    protected String trimWhitespace(String contextPath) {
        StringBuffer withoutSpaces = new StringBuffer();
        StringTokenizer st = new StringTokenizer(contextPath);
        while (st.hasMoreTokens()) {
            withoutSpaces.append(st.nextToken());
        }
        return withoutSpaces.toString();
    }
}

