/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.util;

import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.file.FileUtil;
import org.soitoolkit.commons.mule.util.MiscUtil;

public class RecursiveResourceBundle {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    private Properties properties = new Properties();

    public RecursiveResourceBundle() {
    }

    public RecursiveResourceBundle(String ... baseNames) {
        for (String baseName : baseNames) {
            logger.debug("Loading properties from ResourceBundle: {}", (Object)baseName);
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(baseName);
            }
            catch (MissingResourceException e) {
                logger.warn("Failed to laod properties from ResourceBundle: {}, continue with the next bundle", (Object)baseName);
            }
            if (bundle == null) continue;
            Properties p = MiscUtil.convertResourceBundleToProperties(bundle);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                logger.debug("Adding property: {} = {}", entry.getKey(), entry.getValue());
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public String getString(String key) {
        String value = this.properties.getProperty(key);
        String parsedValue = value == null ? null : MiscUtil.parseStringValue(value, this.properties);
        logger.debug("{} = {}", (Object)key, (Object)parsedValue);
        return parsedValue;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

