/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.test;

import java.util.EventListener;
import javax.servlet.Servlet;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mule.api.MuleContext;
import org.mule.transport.servlet.MuleReceiverServlet;
import org.mule.transport.servlet.MuleServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.test.MuleServerWithServletContainer;

public class ServletContainerWithMuleReceiverServlet {
    private static Logger log = LoggerFactory.getLogger(MuleServerWithServletContainer.class);
    protected int httpPort = -1;
    protected String contextPath = null;
    protected String muleReceiverServletUri = null;
    protected MuleContext muleContext = null;
    protected String muleServerId = null;
    protected Server httpServer = null;

    public ServletContainerWithMuleReceiverServlet(int httpPort, String contextPath, String muleReceiverServletUri, MuleContext muleContext, String muleServerId) {
        this.httpPort = httpPort;
        this.contextPath = contextPath;
        this.muleReceiverServletUri = muleReceiverServletUri;
        this.muleContext = muleContext;
        this.muleServerId = muleServerId;
    }

    public void start() throws Exception {
        this.httpServer = new Server(this.httpPort);
        String path = this.contextPath;
        if (path.equals("")) {
            path = "/";
        }
        Context c = new Context((HandlerContainer)this.httpServer, path, 1);
        c.addEventListener((EventListener)new MuleServletContextListener(this.muleContext, this.muleServerId));
        MuleReceiverServlet servlet = new MuleReceiverServlet();
        c.addServlet(new ServletHolder((Servlet)servlet), this.muleReceiverServletUri + "/*");
        this.httpServer.start();
        if (log.isInfoEnabled()) {
            log.info("Mule Receiver Servlet available at: http://localhost:{}{}{}", (Object[])new String[]{Integer.toString(this.httpPort), this.contextPath, this.muleReceiverServletUri});
        }
    }

    public void shutdown() throws Exception {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            this.httpServer.stop();
        }
    }
}

