/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.stream.XMLStreamReader;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transport.jms.transformers.ObjectToJMSMessage;
import org.soitoolkit.commons.mule.util.XmlUtil;

public class ObjectToJMSMessageTransformer
extends ObjectToJMSMessage {
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        Object payload = message.getPayload();
        if (payload instanceof XMLStreamReader) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"XMLStreamReader detected, converting it to a String so that Mule's ObjectToJMSMessage - transformer can make a JMS out of it");
            }
            payload = XmlUtil.convertXMLStreamReaderToString((XMLStreamReader)payload, outputEncoding);
            message.setPayload(payload);
        }
        return super.transformMessage(message, outputEncoding);
    }

    public void setJmsProperties(MuleMessage message, Message msg) throws JMSException {
        String muleReplyTo;
        message.removeProperty("http.method");
        message.removeProperty("Content-Type");
        message.removeProperty("Content-Length");
        message.removeProperty("User-Agent");
        message.removeProperty("http.context.path");
        message.removeProperty("http.request");
        message.removeProperty("http.request.path");
        Object muleReplyToObj = message.getProperty("MULE_REPLYTO");
        String string = muleReplyTo = muleReplyToObj == null ? null : muleReplyToObj.toString();
        if (muleReplyTo != null && muleReplyTo.startsWith("wmq://")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"WMQ-Transport detected, removing the two // in queuename!");
            }
            String newMuleReplyQueue = "wmq:" + muleReplyTo.substring("wmq://".length());
            message.setProperty("MULE_REPLYTO", (Object)newMuleReplyQueue);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Replaced " + muleReplyTo + " with " + newMuleReplyQueue));
            }
        }
        super.setJmsProperties(message, msg);
    }
}

